package resourcesRes.subRes;

import java.util.ArrayList;

import resourcesRes.ResId;
import resourcesRes.libraryRes.LibAction;
import resourcesRes.libraryRes.LibManager;
public class Event
{
    //mouse event types
    public static final byte EV_LEFT_BUTTON=0;
    public static final byte EV_RIGHT_BUTTON=1;
    public static final byte EV_MIDDLE_BUTTON=2;
    public static final byte EV_NO_BUTTON=3;
    public static final byte EV_LEFT_PRESS=4;
    public static final byte EV_RIGHT_PRESS=5;
    public static final byte EV_MIDDLE_PRESS=6;
    public static final byte EV_LEFT_RELEASE=7;
    public static final byte EV_RIGHT_RELEASE=8;
    public static final byte EV_MIDDLE_RELEASE=9;
    public static final byte EV_MOUSE_ENTER=10;
    public static final byte EV_MOUSE_LEAVE=11;
    public static final byte EV_MOUSE_WHEEL_UP=60;
    public static final byte EV_MOUSE_WHEEL_DOWN=61;
    public static final byte EV_GLOBAL_LEFT_BUTTON=50;
    public static final byte EV_GLOBAL_RIGHT_BUTTON=51;
    public static final byte EV_GLOBAL_MIDDLE_BUTTON=52;
    public static final byte EV_GLOBAL_LEFT_PRESS=53;
    public static final byte EV_GLOBAL_RIGHT_PRESS=54;
    public static final byte EV_GLOBAL_MIDDLE_PRESS=55;
    public static final byte EV_GLOBAL_LEFT_RELEASE=56;
    public static final byte EV_GLOBAL_RIGHT_RELEASE=57;
    public static final byte EV_GLOBAL_MIDDLE_RELEASE=58;
    public static final byte EV_JOYSTICK1_LEFT=16;
    public static final byte EV_JOYSTICK1_RIGHT=17;
    public static final byte EV_JOYSTICK1_UP=18;
    public static final byte EV_JOYSTICK1_DOWN=19;
    public static final byte EV_JOYSTICK1_BUTTON1=21;
    public static final byte EV_JOYSTICK1_BUTTON2=22;
    public static final byte EV_JOYSTICK1_BUTTON3=23;
    public static final byte EV_JOYSTICK1_BUTTON4=24;
    public static final byte EV_JOYSTICK1_BUTTON5=25;
    public static final byte EV_JOYSTICK1_BUTTON6=26;
    public static final byte EV_JOYSTICK1_BUTTON7=27;
    public static final byte EV_JOYSTICK1_BUTTON8=28;
    public static final byte EV_JOYSTICK2_LEFT=31;
    public static final byte EV_JOYSTICK2_RIGHT=32;
    public static final byte EV_JOYSTICK2_UP=33;
    public static final byte EV_JOYSTICK2_DOWN=34;
    public static final byte EV_JOYSTICK2_BUTTON1=36;
    public static final byte EV_JOYSTICK2_BUTTON2=37;
    public static final byte EV_JOYSTICK2_BUTTON3=38;
    public static final byte EV_JOYSTICK2_BUTTON4=39;
    public static final byte EV_JOYSTICK2_BUTTON5=40;
    public static final byte EV_JOYSTICK2_BUTTON6=41;
    public static final byte EV_JOYSTICK2_BUTTON7=42;
    public static final byte EV_JOYSTICK2_BUTTON8=43;
    
    //other event types
    public static final byte EV_OUTSIDE=0;
    public static final byte EV_BOUNDARY=1;
    public static final byte EV_GAME_START=2;
    public static final byte EV_GAME_END=3;
    public static final byte EV_ROOM_START=4;
    public static final byte EV_ROOM_END=5;
    public static final byte EV_NO_MORE_LIVES=6;
    public static final byte EV_NO_MORE_HEALTH=9;
    public static final byte EV_ANIMATION_END=7;
    public static final byte EV_END_OF_PATH=8;
    public static final byte EV_USER0=10;
    public static final byte EV_USER1=11;
    public static final byte EV_USER2=12;
    public static final byte EV_USER3=13;
    public static final byte EV_USER4=14;
    public static final byte EV_USER5=15;
    public static final byte EV_USER6=16;
    public static final byte EV_USER7=17;
    public static final byte EV_USER8=18;
    public static final byte EV_USER9=19;
    public static final byte EV_USER10=20;
    public static final byte EV_USER11=21;
    public static final byte EV_USER12=22;
    public static final byte EV_USER13=23;
    public static final byte EV_USER14=24;
    public static final byte EV_USER15=25;
    
    //step event types
    public static final byte EV_STEP_NORMAL=0;
    public static final byte EV_STEP_BEGIN=1;
    public static final byte EV_STEP_END=2;
    
    //XXX NOTE: java.awt.event.KeyEvent has constants appropriate for keyboard events
    
    /*Another note: The constant definitions were generated by a small GM program,
     which parses the clipboard (with parts of the gm manual on it) and generates the Java definitions.*/
    
    public int Id=0;
    public ResId Other=null;//For collision Events
    private ArrayList<Action> Actions=new ArrayList<Action>();
    public int NoActions()
    {
        return Actions.size();
    }
    public Action addAction()
    {
        Action act=new Action();
        Actions.add(act);
        return act;
    }
    public Action addAction(int LibId,int LibActionId, LibManager src)//adds an action preset to the properties of given LibAction
    {
        Action act=new Action();
        LibAction lact=LibManager.getLibAction(LibId,LibActionId);
        if(lact!=null)
        {
            act.LibActionId=LibActionId;
            act.LibraryId=LibId;
            act.ActionKind=lact.ActionKind;
            act.Question=lact.Question;
            act.CanApplyTo=lact.CanApplyTo;
            act.AllowRelative=lact.AllowRelative;
            act.ExecType=lact.ExecType;
            act.ExecFunction=lact.ExecFunction;
            act.ExecCode=lact.ExecCode;
            act.NoArguments=lact.NoLibArguments;
            for(int i=0;i<lact.NoLibArguments;i++)
            {
                act.Arguments[i].Kind=lact.LibArguments[i].Kind;
                switch(act.Arguments[i].Kind)
                {
                    case Argument.ARG_SPRITE:
                    case Argument.ARG_SOUND:
                    case Argument.ARG_BACKGROUND:
                    case Argument.ARG_PATH:
                    case Argument.ARG_SCRIPT:
                    case Argument.ARG_GMOBJECT:
                    case Argument.ARG_ROOM:
                    case Argument.ARG_FONT:
                    case Argument.ARG_TIMELINE: act.Arguments[i].Res=null;break;
                    default: act.Arguments[i].Val=lact.LibArguments[i].DefaultVal;break;
                }
            }
        }
        Actions.add(act);
        return act;
    }
    public Action getAction(int ListIndex)
    {
        if (ListIndex>=0&&ListIndex<NoActions())
            return Actions.get(ListIndex);
        return null;
    }
    public void removeAction(int ListIndex)
    {
        if (ListIndex>=0&&ListIndex<NoActions())
            Actions.remove(ListIndex);
    }
    public void clearActions()
    {
        Actions.clear();
    }
}
